//
//  GHScreen.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 8/11/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

/**
 *  Screens enabled on device.
 */
typedef NS_OPTIONS(NSInteger, GHScreenType){
    /** Activate the steps screen. The vivofit and vivofit2 will show steps screen even if not set. */
    GHScreenSteps = 1 << 0,

    /** Activate the steps goal screen */
    GHScreenGoal = 1 << 1,

    /** Activate the distance screen */
    GHScreenDistance = 1 << 2,

    /** Activate the calories screen */
    GHScreenCalories = 1 << 3,

    /** Activate the time screen */
    GHScreenTime = 1 << 4,

    /** Activate the date screen. Depends on the time screen */
    GHScreenDate = 1 << 5,

    /** Activate the heart rate screen */
    GHScreenHeartRate = 1 << 6,
    
    /** Activate the instensity minutes screen */
    GHScreenIntensity = 1 << 7,
    
    /** Activate the floors climbed screen */
    GHScreenFloorsClimbed = 1 << 8,
    
    /** Activate the timer screen */
    GHScreenTimer = 1 << 9,
    
    /** Activate the notifications screen */
    GHScreenNotifications = 1 << 10,
    
    /** Activate the stress screen */
    GHScreenStress = 1 << 11,

    /** Activate the Virb screen */
    GHScreenVirb = 1 << 12,

    /** Activate the body battery screen */
    GHScreenBodyBattery = 1 << 13,

    /** Activate the music control screen */
    GHScreenMusicControl = 1 << 14,

    /** Activate the custom message screen */
    GHScreenCustomMessage = 1 << 15,

    /** Activate the calendar screen */
    GHScreenCalendar = 1 << 16,

    /** Activate the weather screen */
    GHScreenWeather = 1 << 17,

    /** Activate the hydration screen */
    GHScreenHydration = 1 << 18,

    /** Activate the respiration screen */
    GHScreenRespiration = 1 << 19,

    /** Activate the menstrual tracking screen */
    GHScreenMenstrualTracking = 1 << 20,

    /** Activate the Status and Time screen */
    GHScreenStatusAndTime = 1 << 21
};


#pragma mark -
/**
 *  The GHScreen class provides information about a screen.
 */
@interface GHScreen : NSObject<NSCoding, NSCopying>
    
/** The type of the screen. Refer to GHScreenType for additional information. */
@property (nonatomic) GHScreenType type;

/** Indicates whether the screen should be displayed on the device. */
@property (nonatomic) BOOL showOnDevice;

/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;

/**
 *  Prefered initialization method.
 *  @param screen The GHScreen to initialize the screen with.
 */
- (instancetype) initWithScreen:(GHScreen *)screen;


@end
